package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetTextLED extends Phidget
	{
		private var numRows:int = com.phidgets.Constants.PUNK_INT;
		private var numColumns:int = com.phidgets.Constants.PUNK_INT;
		private var brightness:int = com.phidgets.Constants.PUNK_INT;
		
		public function PhidgetTextLED(){
			super("PhidgetTextLED");
			keyCountNeeded += 2;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numRows = com.phidgets.Constants.PUNK_INT;
			numColumns = com.phidgets.Constants.PUNK_INT;
			brightness = com.phidgets.Constants.PUNK_INT;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfRows":
					numRows = int(value);
					keyCount++;
					break;
				case "NumberOfColumns":
					numColumns = int(value);
					keyCount++;
					break;
				case "Brightness":
					brightness = int(value);
					break;
			}
		}
		
		//Getters
		public function get NumberOfRows():int{
			if(numRows == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numRows;
		}
		public function get NumberOfColumns():int{
			if(numColumns == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numColumns;
		}
		public function get Brightness():int{
			if(brightness == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return brightness;
		}
		
		//Setters
		public function set Brightness(val:int):void{ 
			_phidgetSocket.setKey(makeKey("brightness"), val.toString(), true);
		}
		public function setDisplayString(index:int, val:String):void{ 
			_phidgetSocket.setKey(makeIndexedKey("DisplayString", index, numRows), val, true);
		}
	}
}