package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetTextLCD extends Phidget
	{
		private var numRows:int = com.phidgets.Constants.PUNK_INT;
		private var numColumns:int = com.phidgets.Constants.PUNK_INT;
		private var backlight:int = com.phidgets.Constants.PUNK_BOOL;
		private var cursorOn:int = com.phidgets.Constants.PUNK_BOOL;
		private var cursorBlink:int = com.phidgets.Constants.PUNK_BOOL;
		private var contrast:int = com.phidgets.Constants.PUNK_INT;
		
		public function PhidgetTextLCD(){
			super("PhidgetTextLCD");
			keyCountNeeded += 2;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numRows = com.phidgets.Constants.PUNK_INT;
			numColumns = com.phidgets.Constants.PUNK_INT;
			backlight = com.phidgets.Constants.PUNK_BOOL;
			cursorOn = com.phidgets.Constants.PUNK_BOOL;
			cursorBlink = com.phidgets.Constants.PUNK_BOOL;
			contrast = com.phidgets.Constants.PUNK_INT;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfRows":
					numRows = int(value);
					keyCount++;
					break;
				case "NumberOfColumns":
					numColumns = int(value);
					keyCount++;
					break;
				case "Backlight":
					backlight = int(value);
					break;
				case "CursorOn":
					cursorOn = int(value);
					break;
				case "CursorBlink":
					cursorBlink = int(value);
					break;
				case "Contrast":
					contrast = int(value);
					break;
			}
		}
		
		//Getters
		public function get NumberOfRows():int{
			if(numRows == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numRows;
		}
		public function get NumberOfColumns():int{
			if(numColumns == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numColumns;
		}
		public function get Backlight():Boolean{
			return intToBool(backlight);
		}
		public function get Cursor():Boolean{
			return intToBool(backlight);
		}
		public function get CursorBlink():Boolean{
			return intToBool(backlight);
		}
		public function get Contrast():int{
			if(contrast == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return contrast;
		}
		
		//Setters
		public function set Backlight(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("Backlight"), boolToInt(val).toString(), true);
		}
		public function set Cursor(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("CursorOn"), boolToInt(val).toString(), true);
		}
		public function set CursorBlink(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("CursorBlink"), boolToInt(val).toString(), true);
		}
		public function set Contrast(val:int):void{ 
			_phidgetSocket.setKey(makeKey("Contrast"), val.toString(), true);
		}
		public function setDisplayString(index:int, val:String):void{ 
			_phidgetSocket.setKey(makeIndexedKey("DisplayString", index, numRows), val, true);
		}
		public function setCustomCharacter(index:int, val1:int, val2:int):void {
			var key:String = makeIndexedKey("CustomCharacter", index, 16);
			if(index < 8) throw new PhidgetError(com.phidgets.Constants.EPHIDGET_OUTOFBOUNDS);
			var val:String = val1+","+val2;
			_phidgetSocket.setKey(key, val, true);
		}
	}
}