package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetTemperatureSensor extends Phidget
	{
		private var numSensors:int = com.phidgets.Constants.PUNK_INT;
		private var potentialMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var potentialMax:Number = com.phidgets.Constants.PUNK_NUM;
		private var ambientTemperatureMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var ambientTemperatureMax:Number = com.phidgets.Constants.PUNK_NUM;
		private var temperatureMins:Array = new Array(8);
		private var temperatureMaxs:Array = new Array(8);
		
		private var ambientTemperature:Number = com.phidgets.Constants.PUNK_NUM;
		private var thermocoupleTypes:Array = new Array(8);
		private var temperatures:Array = new Array(8);
		private var potentials:Array = new Array(8);
		private var temperatureTriggers:Array = new Array(8);
		
		public static const PHIDGET_TEMPERATURE_SENSOR_K_TYPE:int = 1;
		public static const PHIDGET_TEMPERATURE_SENSOR_J_TYPE:int = 2;
		public static const PHIDGET_TEMPERATURE_SENSOR_E_TYPE:int = 3;
		public static const PHIDGET_TEMPERATURE_SENSOR_T_TYPE:int = 4;
		
		public function PhidgetTemperatureSensor(){
			super("PhidgetTemperatureSensor");
			keyCountNeeded += 7;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numSensors = com.phidgets.Constants.PUNK_INT;
			potentialMin = com.phidgets.Constants.PUNK_NUM;
			potentialMax = com.phidgets.Constants.PUNK_NUM;
			ambientTemperatureMin = com.phidgets.Constants.PUNK_NUM;
			ambientTemperatureMax = com.phidgets.Constants.PUNK_NUM;
			temperatureMins = new Array(8);
			temperatureMaxs = new Array(8);
		
			ambientTemperature = com.phidgets.Constants.PUNK_NUM;
			temperatures = new Array(8);
			potentials = new Array(8);
			temperatureTriggers = new Array(8);
			thermocoupleTypes = new Array(8);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfSensors":
					numSensors = int(value);
					keyCount++;
					break;
				case "ThermocoupleType":
					thermocoupleTypes[index] = value;
					break;
				case "AmbientTemperature":
					ambientTemperature = Number(value);
					break;
				case "AmbientTemperatureMin":
					ambientTemperatureMin = Number(value);
					keyCount++;
					break;
				case "AmbientTemperatureMax":
					ambientTemperatureMax = Number(value);
					keyCount++;
					break;
				case "Temperature":
					temperatures[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.TEMPERATURE_CHANGE,this,Number(temperatures[index]),index));
					break;
				case "TemperatureMin":
					temperatureMins[index] = value;
					keyCount++;
					break;
				case "TemperatureMax":
					temperatureMaxs[index] = value;
					keyCount++;
					break;
				case "Potential":
					potentials[index] = value;
					break;
				case "PotentialMin":
					potentialMin = Number(value);
					keyCount++;
					break;
				case "PotentialMax":
					potentialMax = Number(value);
					keyCount++;
					break;
				case "Trigger":
					temperatureTriggers[index] = value;
					break;
			}
		}
		
		//Getters
		public function get NumberOfTemperatureInputs():int{
			if(numSensors == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numSensors;
		}
		public function getThermocoupleType(index:int):int{
			return int(indexArray(thermocoupleTypes, index, numSensors));
		}
		public function getTemperature(index:int):Number{
			return Number(indexArray(temperatures, index, numSensors));
		}
		public function getTemperatureMin(index:int):Number{
			return Number(indexArray(temperatureMins, index, numSensors));
		}
		public function getTemperatureMax(index:int):Number{
			return Number(indexArray(temperatureMaxs, index, numSensors));
		}
		public function get AmbientTemperature():Number{
			if(ambientTemperature == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return ambientTemperature;
		}
		public function get AmbientTemperatureMin():Number{
			if(ambientTemperatureMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return ambientTemperatureMin;
		}
		public function get AmbientTemperatureMax():Number{
			if(ambientTemperatureMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return ambientTemperatureMax;
		}
		public function getPotential(index:int):Number{
			return Number(indexArray(potentials, index, numSensors));
		}
		public function get PotentialMin():Number{
			if(potentialMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return potentialMin;
		}
		public function get PotentialMax():Number{
			if(potentialMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return potentialMax;
		}
		public function getTemperatureChangeTrigger(index:int):Number{
			return Number(indexArray(temperatureTriggers, index, numSensors));
		}
		
		//Setters
		public function setTemperatureChangeTrigger(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Trigger", index, numSensors), val.toString(), true);
		}
		public function setThermocoupleType(index:int, val:int):void{ 
			_phidgetSocket.setKey(makeIndexedKey("ThermocoupleType", index, numSensors), val.toString(), true);
		}
	}
}