package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetServo extends Phidget
	{
		private var numServos:int = com.phidgets.Constants.PUNK_INT;
		private var positionMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var positionMax:Number = com.phidgets.Constants.PUNK_NUM;
		
		private var positions:Array = new Array(4);
		private var motorEngagedState:Array = new Array(4);
		
		public function PhidgetServo(){
			super("PhidgetServo");
			keyCountNeeded += 3;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			positionMin = com.phidgets.Constants.PUNK_NUM;
			positionMax = com.phidgets.Constants.PUNK_NUM;
			numServos = com.phidgets.Constants.PUNK_INT;
			positions = new Array(4);
			motorEngagedState = new Array(4);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfMotors":
					numServos = int(value);
					keyCount++;
					break;
				case "PositionMin":
					positionMin = Number(value);
					keyCount++;
					break;
				case "PositionMax":
					positionMax = Number(value);
					keyCount++;
					break;
				case "MotorOn":
					motorEngagedState[index] = value;
					break;
				case "Position":
					positions[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.POSITION_CHANGE,this,Number(positions[index]),index));
					break;
			}
		}
		
		//Getters
		public function get NumberOfMotors():int{
			if(numServos == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numServos;
		}
		public function getMotorPosition(index:int):Number{
			return Number(indexArray(positions, index, numServos));
		}
		public function getMotorOn(index:int):Boolean{
			return intToBool(motorEngagedState[index]);
		}
		public function get PositionMin():Number{
			if(positionMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return positionMin;
		}
		public function get PositionMax():Number{
			if(positionMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return positionMax;
		}
		
		//Setters
		public function setMotorPosition(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Position", index, numServos), val.toString(), true);
		}
		public function setMotorOn(index:int, val:Boolean):void{ 
			_phidgetSocket.setKey(makeIndexedKey("MotorOn", index, numServos), boolToInt(val).toString(), true);
		}
	}
}