﻿package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetRFID extends Phidget
	{
		private var numOutputs:int = com.phidgets.Constants.PUNK_INT;
		
		private var lastTag:String = null;
		private var tagState:int = com.phidgets.Constants.PUNK_BOOL;
		private var antennaState:int = com.phidgets.Constants.PUNK_BOOL;
		private var ledState:int = com.phidgets.Constants.PUNK_BOOL;
		private var outputs:Array = new Array(2);
		
		public function PhidgetRFID(){
			super("PhidgetRFID");
			keyCountNeeded += 1;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numOutputs = com.phidgets.Constants.PUNK_INT;
			lastTag = null;
			outputs = new Array(2);
			tagState = com.phidgets.Constants.PUNK_BOOL;
			antennaState = com.phidgets.Constants.PUNK_BOOL;
			ledState = com.phidgets.Constants.PUNK_BOOL;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfOutputs":
					numOutputs = int(value);
					keyCount++;
					break;
				case "Tag":
					lastTag = value;
					tagState = com.phidgets.Constants.PTRUE;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.TAG,this,lastTag));
					break;
				case "TagLoss":
					lastTag = value;
					tagState = com.phidgets.Constants.PFALSE;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.TAG_LOST,this,lastTag));
					break;
				case "TagState":
					tagState = int(value);
					break;
				case "AntennaOn":
					antennaState = int(value);
					break;
				case "LEDOn":
					ledState = int(value);
					break;
				case "Output":
					outputs[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.OUTPUT_CHANGE,this,intToBool(outputs[index]),index));
					break;
			}
		}
		
		//Getters
		public function get NumberOfOutputs():int{
			if(numOutputs == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numOutputs;
		}
		public function getLastTag():String{
			if(lastTag == null)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return lastTag;
		}
		public function getOutputState(index:int):Boolean{
			return intToBool(int(indexArray(outputs, index, numOutputs)));
		}
		public function get Antenna():Boolean{
			return intToBool(antennaState);
		}
		public function get LED():Boolean{
			return intToBool(ledState);
		}
		public function get TagPresent():Boolean{
			return intToBool(tagState);
		}
		
		//Setters
		public function setOutputState(index:int, val:Boolean):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Output", index, numOutputs), boolToInt(val).toString(), true);
		}
		public function set Antenna(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("AntennaOn"), boolToInt(val).toString(), true);
		}
		public function set LED(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("LEDOn"), boolToInt(val).toString(), true);
		}
	}
}