package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetPHSensor extends Phidget
	{
		private var phMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var phMax:Number = com.phidgets.Constants.PUNK_NUM;
		private var potentialMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var potentialMax:Number = com.phidgets.Constants.PUNK_NUM;
		
		private var ph:Number = com.phidgets.Constants.PUNK_NUM;
		private var potential:Number = com.phidgets.Constants.PUNK_NUM;
		private var phTrigger:Number = com.phidgets.Constants.PUNK_NUM;
		
		public function PhidgetPHSensor(){
			super("PhidgetPHSensor");
			keyCountNeeded += 4;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			phMin = com.phidgets.Constants.PUNK_NUM;
			phMax = com.phidgets.Constants.PUNK_NUM;
			potentialMin = com.phidgets.Constants.PUNK_NUM;
			potentialMax = com.phidgets.Constants.PUNK_NUM;
		
			ph = com.phidgets.Constants.PUNK_NUM;
			potential = com.phidgets.Constants.PUNK_NUM;
			phTrigger = com.phidgets.Constants.PUNK_NUM;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "PHMin":
					phMin = Number(value);
					keyCount++;
					break;
				case "PHMax":
					phMax = Number(value);
					keyCount++;
					break;
				case "PotentialMin":
					potentialMin = Number(value);
					keyCount++;
					break;
				case "PotentialMax":
					potentialMax = Number(value);
					keyCount++;
					break;
				case "PH":
					ph = Number(value);
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.PH_CHANGE,this,ph));
					break;
				case "Trigger":
					phTrigger = Number(value);
					break;
				case "Potential":
					potential = Number(value);
					break;
			}
		}
		
		//Getters
		public function get PH():Number{
			if(ph == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return ph;
		}
		public function get PHMin():Number{
			if(phMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return phMin;
		}
		public function get PHMax():Number{
			if(phMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return phMax;
		}
		public function get Potential():Number{
			if(potential == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return potential;
		}
		public function get PotentialMin():Number{
			if(potentialMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return potentialMin;
		}
		public function get PotentialMax():Number{
			if(potentialMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return potentialMax;
		}
		public function get PHChangeTrigger():Number{
			if(phTrigger == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return phTrigger;
		}
		
		//Setters
		public function set PHChangeTrigger(val:Number):void{ 
			_phidgetSocket.setKey(makeKey("Trigger"), val.toString(), true);
		}
		public function setTemperature(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeKey("Temperature"), val.toString(), true);
		}
	}
}