package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetMotorControl extends Phidget
	{
		private var numMotors:int = com.phidgets.Constants.PUNK_INT;
		private var numInputs:int = com.phidgets.Constants.PUNK_INT;
		private var accelerationMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var accelerationMax:Number = com.phidgets.Constants.PUNK_NUM;
		
		private var velocities:Array = new Array(2);
		private var accelerations:Array = new Array(2);
		private var currents:Array = new Array(2);
		private var inputs:Array = new Array(4);
		
		public function PhidgetMotorControl(){
			super("PhidgetMotorControl");
			keyCountNeeded += 4;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numMotors = com.phidgets.Constants.PUNK_INT;
			numInputs = com.phidgets.Constants.PUNK_INT;
			accelerationMin = com.phidgets.Constants.PUNK_NUM;
			accelerationMax = com.phidgets.Constants.PUNK_NUM;
			inputs = new Array(4);
			velocities = new Array(2);
			accelerations = new Array(2);
			currents = new Array(2);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfMotors":
					numMotors = int(value);
					keyCount++;
					break;
				case "NumberOfInputs":
					numInputs = int(value);
					keyCount++;
					break;
				case "AccelerationMin":
					accelerationMin = Number(value);
					keyCount++;
					break;
				case "AccelerationMax":
					accelerationMax = Number(value);
					keyCount++;
					break;
				case "Input":
					inputs[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.INPUT_CHANGE,this,intToBool(inputs[index]),index));
					break;
				case "Velocity":
					velocities[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.VELOCITY_CHANGE,this,Number(velocities[index]),index));
					break;
				case "Acceleration":
					accelerations[index] = value;
					break;
				case "Current":
					currents[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.CURRENT_CHANGE,this,Number(currents[index]),index));
					break;
			}
		}
		
		//Getters
		public function get NumberOfInputs():int{
			if(numInputs == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numInputs;
		}
		public function get NumberOfMotors():int{
			if(numMotors == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numMotors;
		}
		public function get AccelerationMin():Number{
			if(accelerationMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMin;
		}
		public function get AccelerationMax():Number{
			if(accelerationMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMax;
		}
		public function getInputState(index:int):Boolean{
			return intToBool(int(indexArray(inputs, index, numInputs)));
		}
		public function getAcceleration(index:int):Number{
			return Number(indexArray(accelerations, index, numMotors));
		}
		public function getMotorSpeed(index:int):Number{
			return Number(indexArray(velocities, index, numMotors));
		}
		public function getCurrent(index:int):Number{
			return Number(indexArray(currents, index, numMotors));
		}
		
		//Setters
		public function setAcceleration(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Acceleration", index, numMotors), val.toString(), true);
		}
		public function setMotorSpeed(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Velocity", index, numMotors), val.toString(), true);
		}
	}
}