package com.phidgets
{
	import flash.events.Event;
	import com.phidgets.events.PhidgetManagerEvent;
	import com.phidgets.events.PhidgetErrorEvent;
	import flash.events.EventDispatcher;
	
	public class PhidgetManager extends EventDispatcher
	{
		protected var _phidgetSocket:PhidgetSocket = null;
		
		private var calledClose:Boolean = false;

		public function openRemote(serverID:String, password:String = null):void {
			throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNSUPPORTED);
		}
		
		public function open(address:String, port:Number, password:String = null):void {
			_phidgetSocket = new PhidgetSocket();
			_phidgetSocket.connect(address, port, password, onConnected, onDisconnected, onError);
		}
		
		public function close():void {
			calledClose = true;
			_phidgetSocket.close();
		}
		
		private function onConnected():void {
			//listen
			var pattern:String = "^/PSK/List/";
			_phidgetSocket.setListener(pattern, onPhidgetManagerData);
			
			dispatchEvent(new PhidgetManagerEvent(PhidgetManagerEvent.CONNECT, this));
		}
		
		private function onDisconnected():void {
			if(!calledClose)
				dispatchEvent(new PhidgetManagerEvent(PhidgetManagerEvent.DISCONNECT, this));
			calledClose = false;
		}
		
		private function onError(error:PhidgetError):void {
			dispatchEvent(new PhidgetErrorEvent(PhidgetErrorEvent.ERROR,this,error));
		}
		
		private function onPhidgetManagerData(key:String, val:String, reason:int):void
		{
			//trace("Key: "+key+" Val: "+val+" Reason: "+reason);
				
			if(reason != com.phidgets.Constants.ENTRY_REMOVING)
			{
				var dataArray:Array = key.split("/");
				
				var deviceType:String = dataArray[3];
				var serialNumber:int = int(dataArray[4]);
				var deviceIDSpec:int = int(dataArray[5]);
				var deviceVersion:int = int(dataArray[6]);
				//var deviceLabel:String = dataArray[7];
				//deviceLabel = deviceLabel.substring(1,deviceLabel.length - 1);
				
				//trace(deviceType+"<>"+serialNumber+"<>"+deviceIDSpec+"<>"+deviceVersion+"<>"+deviceLabel);
				
				var phidget:Phidget = new Phidget(deviceType);
					
				if(val == "Attached")
				{
					phidget.initForManager(serialNumber, deviceVersion, deviceType, 
						Constants.Phid_DeviceSpecificName[deviceIDSpec],
						true, _phidgetSocket);
					dispatchEvent(new PhidgetManagerEvent(PhidgetManagerEvent.ATTACH,this,phidget));
				}
				if(val == "Detached") 
				{
					phidget.initForManager(serialNumber, deviceVersion, deviceType, 
						Constants.Phid_DeviceSpecificName[deviceIDSpec],
						false, _phidgetSocket);
					dispatchEvent(new PhidgetManagerEvent(PhidgetManagerEvent.DETACH,this,phidget));
				}
			}
		}
		
		//From the socket
		public function get isConnected ():Boolean{
			return _phidgetSocket.isConnected;
		}
		public function get Address():String{
			if(_phidgetSocket.Address == null)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return _phidgetSocket.Address;
		}
		public function get Port():int{
			if(_phidgetSocket.Port == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return _phidgetSocket.Port;
		}
		public function get ServerID():String{
			if(_phidgetSocket.ServerID == null)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return _phidgetSocket.ServerID;
		}
	}
}