package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetLED extends Phidget
	{
		private var numLEDs:int = com.phidgets.Constants.PUNK_INT;
		private var leds:Array = new Array(64);
		
		public function PhidgetLED(){
			super("PhidgetLED");
			keyCountNeeded += 1;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numLEDs = com.phidgets.Constants.PUNK_INT;
			leds = new Array(64);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfLEDs":
					numLEDs = int(value);
					keyCount++;
					break;
				case "Brightness":
					leds[index] = value;
					break;
			}
		}
		
		//Getters
		public function get NumberOfLEDs():int{
			if(numLEDs == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numLEDs;
		}
		public function getDiscreteLED(index:int):int{
			return int(indexArray(leds, index, numLEDs));
		}
		
		//Setters
		public function setDiscreteLED(index:int, val:int):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Brightness", index, numLEDs), val.toString(), true);
		}
	}
}