package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetInterfaceKit extends Phidget
	{
		private var numSensors:int = com.phidgets.Constants.PUNK_INT;
		private var numInputs:int = com.phidgets.Constants.PUNK_INT;
		private var numOutputs:int = com.phidgets.Constants.PUNK_INT;
		
		private var inputs:Array = new Array(32);
		private var outputs:Array = new Array(32);
		private var sensors:Array = new Array(8);
		
		private var sensorTriggers:Array = new Array(8);
		
		private var ratiometric:int = com.phidgets.Constants.PUNK_BOOL;
		
		public function PhidgetInterfaceKit(){
			super("PhidgetInterfaceKit");
			keyCountNeeded += 3;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numSensors = com.phidgets.Constants.PUNK_INT;
			numInputs = com.phidgets.Constants.PUNK_INT;
			numOutputs = com.phidgets.Constants.PUNK_INT;
			inputs = new Array(32);
			outputs = new Array(32);
			sensors = new Array(8);
			sensorTriggers = new Array(8);
			ratiometric = com.phidgets.Constants.PUNK_BOOL;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfSensors":
					numSensors = int(value);
					keyCount++;
					break;
				case "NumberOfInputs":
					numInputs = int(value);
					keyCount++;
					break;
				case "NumberOfOutputs":
					numOutputs = int(value);
					keyCount++;
					break;
				case "Input":
					inputs[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.INPUT_CHANGE,this,intToBool(inputs[index]),index));
					break;
				case "Output":
					outputs[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.OUTPUT_CHANGE,this,intToBool(outputs[index]),index));
					break;
				case "Sensor":
					sensors[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.SENSOR_CHANGE,this,int(sensors[index]),index));
					break;
				case "Trigger":
					sensorTriggers[index] = value;
					break;
				case "Ratiometric":
					ratiometric = int(value);
					break;
			}
		}
		
		//Getters
		public function get NumberOfInputs():int{
			if(numInputs == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numInputs;
		}
		public function get NumberOfOutputs():int{
			if(numOutputs == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numOutputs;
		}
		public function get NumberOfSensors():int{
			if(numSensors == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numSensors;
		}
		public function get Ratiometric():Boolean{
			return intToBool(ratiometric);
		}
		public function getInputState(index:int):Boolean{
			return intToBool(int(indexArray(inputs, index, numInputs)));
		}
		public function getOutputState(index:int):Boolean{
			return intToBool(int(indexArray(outputs, index, numOutputs)));
		}
		public function getSensorValue(index:int):int{
			return int(indexArray(sensors, index, numSensors));
		}
		public function getSensorChangeTrigger(index:int):int{
			return int(indexArray(sensorTriggers, index, numSensors));
		}
		
		//Setters
		public function set Ratiometric(val:Boolean):void{ 
			_phidgetSocket.setKey(makeKey("Ratiometric"), boolToInt(val).toString(), true);
		}
		public function setOutputState(index:int, val:Boolean):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Output", index, numOutputs), boolToInt(val).toString(), true);
		}
		public function setSensorChangeTrigger(index:int, val:int):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Trigger", index, numSensors), val.toString(), true);
		}
	}
}