package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetAdvancedServo extends Phidget
	{
		private var numMotors:int = com.phidgets.Constants.PUNK_INT;
		private var positionMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var positionMax:Number = com.phidgets.Constants.PUNK_NUM;
		private var accelerationMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var accelerationMax:Number = com.phidgets.Constants.PUNK_NUM;
		private var velocityMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var velocityMax:Number = com.phidgets.Constants.PUNK_NUM;
		
		private var velocities:Array = new Array(8);
		private var maxVelocities:Array = new Array(8);
		private var accelerations:Array = new Array(8);
		private var currents:Array = new Array(8);
		private var motorEngagedState:Array = new Array(8);
		private var speedRampingState:Array = new Array(8);
		private var positions:Array = new Array(8);
		
		public function PhidgetAdvancedServo(){
			super("PhidgetAdvancedServo");
			keyCountNeeded += 7;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numMotors = com.phidgets.Constants.PUNK_INT;
			positionMin = com.phidgets.Constants.PUNK_NUM;
			positionMax = com.phidgets.Constants.PUNK_NUM;
			accelerationMin = com.phidgets.Constants.PUNK_NUM;
			accelerationMax = com.phidgets.Constants.PUNK_NUM;
			velocityMin = com.phidgets.Constants.PUNK_NUM;
			velocityMax = com.phidgets.Constants.PUNK_NUM;
			velocities = new Array(8);
			accelerations = new Array(8);
			currents = new Array(8);
			maxVelocities = new Array(8);
			motorEngagedState = new Array(8);
			speedRampingState = new Array(8);
			positions = new Array(8);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfMotors":
					numMotors = int(value);
					keyCount++;
					break;
				case "AccelerationMin":
					accelerationMin = Number(value);
					keyCount++;
					break;
				case "AccelerationMax":
					accelerationMax = Number(value);
					keyCount++;
					break;
				case "PositionMin":
					positionMin = Number(value);
					keyCount++;
					break;
				case "PositionMax":
					positionMax = Number(value);
					keyCount++;
					break;
				case "VelocityMin":
					velocityMin = Number(value);
					keyCount++;
					break;
				case "VelocityMax":
					velocityMax = Number(value);
					keyCount++;
					break;
				case "Position":
					positions[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.POSITION_CHANGE,this,Number(positions[index]),index));
					break;
				case "Acceleration":
					accelerations[index] = value;
					break;
				case "Current":
					currents[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.CURRENT_CHANGE,this,Number(currents[index]),index));
					break;
				case "MotorOn":
					motorEngagedState[index] = value;
					break;
				case "SpeedRampingOn":
					speedRampingState[index] = value;
					break;
				case "MaxVelocity":
					maxVelocities[index] = value;
					break;
				case "Velocity":
					velocities[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.VELOCITY_CHANGE,this,Number(velocities[index]),index));
					break;
			}
		}
		
		//Getters
		public function get NumberOfMotors():int{
			if(numMotors == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numMotors;
		}
		public function get AccelerationMin():Number{
			if(accelerationMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMin;
		}
		public function get AccelerationMax():Number{
			if(accelerationMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMax;
		}
		public function get PositionMin():Number{
			if(positionMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return positionMin;
		}
		public function get PositionMax():Number{
			if(positionMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return positionMax;
		}
		public function get VelocityMin():Number{
			if(velocityMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return velocityMin;
		}
		public function get VelocityMax():Number{
			if(velocityMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return velocityMax;
		}
		public function getAcceleration(index:int):Number{
			return Number(indexArray(accelerations, index, numMotors));
		}
		public function getVelocity(index:int):Number{
			return Number(indexArray(velocities, index, numMotors));
		}
		public function getMaxVelocity(index:int):Number{
			return Number(indexArray(maxVelocities, index, numMotors));
		}
		public function getCurrent(index:int):Number{
			return Number(indexArray(currents, index, numMotors));
		}
		public function getPosition(index:int):Number{
			return Number(indexArray(positions, index, numMotors));
		}
		public function getMotorOn(index:int):Boolean{
			return intToBool(motorEngagedState[index]);
		}
		public function getSpeedRampingOn(index:int):Boolean{
			return intToBool(motorEngagedState[index]);
		}
		
		//Setters
		public function setAcceleration(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Acceleration", index, numMotors), val.toString(), true);
		}
		public function setMaxVelocity(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("MaxVelocity", index, numMotors), val.toString(), true);
		}
		public function setPosition(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Position", index, numMotors), val.toString(), true);
		}
		public function setMotorOn(index:int, val:Boolean):void{ 
			_phidgetSocket.setKey(makeIndexedKey("MotorOn", index, numMotors), boolToInt(val).toString(), true);
		}
		public function setSpeedRampingOn(index:int, val:Boolean):void{ 
			_phidgetSocket.setKey(makeIndexedKey("SpeedRampingOn", index, numMotors), boolToInt(val).toString(), true);
		}
	}
}