﻿package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetAccelerometer extends Phidget
	{
		private var numAxes:int = com.phidgets.Constants.PUNK_INT;
		private var accelerationMin:Number = com.phidgets.Constants.PUNK_NUM;
		private var accelerationMax:Number = com.phidgets.Constants.PUNK_NUM;
		
		private var axes:Array = new Array(3);
		private var axisTriggers:Array = new Array(3);
		
		public function PhidgetAccelerometer(){
			super("PhidgetAccelerometer");
			keyCountNeeded += 3;
		}
		
		override protected function onSpecificPhidgetDetach():void{
			numAxes = com.phidgets.Constants.PUNK_INT;
			accelerationMin = com.phidgets.Constants.PUNK_NUM;
			accelerationMax = com.phidgets.Constants.PUNK_NUM;
			axes = new Array(3);
			axisTriggers = new Array(3);
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "NumberOfAxes":
					numAxes = int(value);
					keyCount++;
					break;
				case "Acceleration":
					axes[index] = value;
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.ACCELERATION_CHANGE,this,Number(axes[index]),index));
					break;
				case "AccelerationMin":
					accelerationMin = Number(value);
					keyCount++;
					break;
				case "AccelerationMax":
					accelerationMax = Number(value);
					keyCount++;
					break;
				case "Trigger":
					axisTriggers[index] = value;
					break;
			}
		}
		
		//Getters
		public function get NumberOfAxes():int{
			if(numAxes == com.phidgets.Constants.PUNK_INT)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return numAxes;
		}
		public function getAcceleration(index:int):Number{
			return Number(indexArray(axes, index, numAxes));
		}
		public function get AccelerationMin():Number{
			if(accelerationMin == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMin;
		}
		public function get AccelerationMax():Number{
			if(accelerationMax == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return accelerationMax;
		}
		public function getAccelerationChangeTrigger(index:int):Number{
			return Number(indexArray(axisTriggers, index, numAxes));
		}
		
		//Setters
		public function setAccelerationChangeTrigger(index:int, val:Number):void{ 
			_phidgetSocket.setKey(makeIndexedKey("Trigger", index, numAxes), val.toString(), true);
		}
	}
}