package com.phidgets
{
	public class Constants
	{
		public static const PHIDGET_ATTACHED:Number = 					0x1
		public static const PHIDGET_NOTATTACHED:Number = 					0x0
		
		public static const PHIDGET_ERROR_CODE_COUNT:Number = 			18
		public static const EPHIDGET_OK:Number = 							0
		public static const EPHIDGET_NOTFOUND:Number = 					1	
		public static const EPHIDGET_NOMEMORY:Number = 					2
		public static const EPHIDGET_UNEXPECTED:Number = 					3
		public static const EPHIDGET_INVALIDARG:Number = 					4
		public static const EPHIDGET_NOTATTACHED:Number = 				5
		public static const EPHIDGET_INTERRUPTED:Number = 				6
		public static const EPHIDGET_INVALID:Number = 					7
		public static const EPHIDGET_NETWORK:Number = 					8
		public static const EPHIDGET_UNKNOWNVAL:Number = 					9
		public static const EPHIDGET_BADPASSWORD:Number = 				10
		public static const EPHIDGET_UNSUPPORTED:Number = 				11
		public static const EPHIDGET_DUPLICATE:Number = 					12
		public static const EPHIDGET_TIMEOUT:Number = 					13
		public static const EPHIDGET_OUTOFBOUNDS:Number = 				14
		public static const EPHIDGET_EVENT:Number = 						15
		public static const EPHIDGET_NETWORK_NOTCONNECTED:Number = 		16
		public static const EPHIDGET_WRONGDEVICE:Number = 				17
		
		public static const PFALSE:int = 									0x00
		public static const PTRUE:int = 									0x01
		public static const PUNK_BOOL:int = 								0x02
		public static const PUNK_INT:int = 								0x7FFFFFFF
		public static const PUNK_NUM:Number = 							1e300
		
		public static const MAXDEVICETYPELENGTH:Number =  				50
		
		public static const PHIDGET_DEVICE_TYPE_COUNT:Number =  			23
		
		public static const PHIDDEF_NOTHING_00:Number = 					0x00 
		public static const PHIDDEF_NOTHING_01:Number = 					0x01 
		public static const PHIDDEF_NOTHING_02:Number = 					0x02 
		public static const PHIDDEF_INTERFACEKIT:Number = 				0x03 
		public static const PHIDDEF_SERVO:Number = 						0x04
		public static const PHIDDEF_HUMIDITYSENSOR:Number = 				0x05
		public static const PHIDDEF_NOTHING_06:Number = 					0x06
		public static const PHIDDEF_RFID:Number = 						0x07
		public static const PHIDDEF_WEIGHTSENSOR:Number = 				0x08
		public static const PHIDDEF_NOTHING_09:Number = 					0x09
		public static const PHIDDEF_TEXTLCD:Number = 						0x0A
		public static const PHIDDEF_MOTORCONTROL:Number = 				0x0B
		public static const PHIDDEF_NOTHING_0C:Number = 					0x0C
		public static const PHIDDEF_LED:Number = 							0x0D
		public static const PHIDDEF_ENCODER:Number = 						0x0E
		public static const PHIDDEF_STEPPER:Number = 						0x0F
		public static const PHIDDEF_TEMPERATURESENSOR:Number = 			0x10
		public static const PHIDDEF_ACCELEROMETER:Number = 				0x11
		public static const PHIDDEF_TEXTLED:Number = 						0x12
		public static const PHIDDEF_PHSENSOR:Number = 					0x13
		public static const PHIDDEF_GYROSCOPE:Number = 					0x14
		public static const PHIDDEF_ADVANCEDSERVO:Number = 				0x15
		public static const PHIDDEF_GPS:Number = 							0x16
		
		public static const PHIDGET_DEVICE_COUNT:Number =  				44
		
		public static const PHIDSPEC_NOTHING:Number = 					0x00
		public static const PHIDSPEC_SERVO_1MOTOR:Number = 				0x01
		public static const PHIDSPEC_INTERFACEKIT_8_8_8:Number = 			0x02
		public static const PHIDSPEC_INTERFACEKIT_0_0_4:Number = 			0x03
		public static const PHIDSPEC_INTERFACEKIT_0_16_16:Number = 		0x04
		public static const PHIDSPEC_INTERFACEKIT_0_5_7:Number = 			0x05
		public static const PHIDSPEC_INTERFACEKIT_0_8_8:Number = 			0x06
		public static const PHIDSPEC_ACCELEROMETER:Number = 				0x07
		public static const PHIDSPEC_TEXTLCD_2_20:Number = 				0x08
		public static const PHIDSPEC_TEXTLCD_2_20_CUSTOM:Number = 		0x09
		public static const PHIDSPEC_TEXTLCD_2_20_COMP1:Number = 			0x0A
		public static const PHIDSPEC_RFID:Number = 						0x0B
		public static const PHIDSPEC_LED:Number = 						0x0C
		public static const PHIDSPEC_TEXTLED:Number = 					0x0D
		public static const PHIDSPEC_MOTORCONTROL:Number = 				0x0E
		public static const PHIDSPEC_TEMPERATURESENSOR:Number = 			0x0F
		public static const PHIDSPEC_STEPPER:Number = 					0x10
		public static const PHIDSPEC_ENCODER:Number = 					0x11
		
		public static const PHIDSPEC_INTERFACEKIT_4_8_8:Number = 			0x12
		public static const PHIDSPEC_SERVO_4MOTOR_OLD:Number = 			0x13
		public static const PHIDSPEC_SERVO_1MOTOR_OLD:Number = 			0x14
		public static const PHIDSPEC_WEIGHTSENSOR:Number = 				0x15
		public static const PHIDSPEC_HUMIDITYSENSOR:Number = 				0x16
		public static const PHIDSPEC_PHSENSOR:Number = 					0x17
		public static const PHIDSPEC_GYROSCOPE:Number = 					0x18
		public static const PHIDSPEC_ADVANCEDSERVO8:Number = 				0x19
		public static const PHIDSPEC_RFIDB:Number = 						0x1A
		public static const PHIDSPEC_TEXTLED2:Number = 					0x1B
		
		public static const PHIDSPEC_LINEAR_TOUCH:Number = 				0x1C
		public static const PHIDSPEC_ROTARY_TOUCH:Number = 				0x1D
		public static const PHIDSPEC_ENCODER_4:Number = 					0x1E
		
		public static const PHIDSPEC_GPS:Number = 						0x1F
		public static const PHIDSPEC_ENCODER_HS:Number = 					0x20
		public static const PHIDSPEC_UNIPOLAR_STEPPER:Number = 			0x21
		public static const PHIDSPEC_BIPOLAR_STEPPER:Number = 			0x22
		public static const PHIDSPEC_JOYSTICK:Number = 					0x23
		public static const PHIDSPEC_TEXTLCD_with_888:Number = 			0x24
		public static const PHIDSPEC_888_with_lcd:Number = 				0x25
		public static const PHIDSPEC_ACCELEROMETER3:Number = 				0x26
		public static const PHIDSPEC_ACCELEROMETER_with_GYRO:Number = 	0x27
		public static const PHIDSPEC_GYRO_with_ACCELEROMETER:Number = 	0x28
		public static const PHIDSPEC_SERVO_4MOTOR:Number = 				0x29
		public static const PHIDSPEC_MOTORCONTROL_HC:Number = 			0x2A
		public static const PHIDSPEC_INTERFACEKIT_0_0_8:Number = 			0x2B
		
		public static const Phid_DeviceName:Array = ["", "", "", 
		"PhidgetInterfaceKit", 
		"PhidgetServo", 
		"PhidgetHumiditySensor","", 
		"PhidgetRFID", 
		"PhidgetWeightSensor", "",
		"PhidgetTextLCD",
		"PhidgetMotorControl", "", 
		"PhidgetLED",
		"PhidgetEncoder",
		"PhidgetStepper",
		"PhidgetTemperatureSensor",
		"PhidgetAccelerometer",
		"PhidgetTextLED",
		"PhidgetPHSensor",
		"PhidgetGyroscope",
		"PhidgetAdvancedServo",
		"PhidgetGPS"];
		
		public static const Phid_ErrorDescriptions:Array = [
		"Function completed successfully.",
		"A Phidget matching the type and or serial number could not be found.", 
		"Memory could not be allocated.",
		"Unexpected Error.  Contact Phidgets Inc. for support.", 
		"Invalid argument passed to function.",
		"Phidget no longer physically attached.", 
		"Read/Write operation was interrupted", 
		"The Error Code is not defined.",
		"Network Error.",
		"Value is Unknown (State not yet received from device).",
		"Authorization Failed.",
		"Not Supported",
		"Duplicated request",
		"Given timeout has been exceeded",
		"Index out of Bounds",
		"A non-null error code was returned from an event handler",
		"A connection to the server does not exist.",
		"Function is not applicable for this device."];
		
		public static const Phid_DeviceSpecificName:Array = [
		"Uninitialized Phidget Handle",
		"Phidget Servo Controller 1-motor",
		"Phidget InterfaceKit 8/8/8",
		"Phidget InterfaceKit 0/0/4",
		"Phidget InterfaceKit 0/16/16",
		"Phidget InterfaceKit 0/5/7",
		"Phidget InterfaceKit 0/8/8",
		
		"Phidget Accelerometer 2-axis",
		
		"Phidget TextLCD Custom",
		"Phidget TextLCD",
		"Phidget TextLCD",
		
		"Phidget RFID",
		
		"Phidget LED 64",
		"Phidget TextLED 1x8",
		"Phidget Low Voltage Motor Controller 2-motor 4-input",
		"Phidget Temperature Sensor",
		"Phidget Stepper",
		"Phidget Encoder 1-encoder 1-input",
		
		/* Obsoleted */
		"Phidget InterfaceKit 4/8/8",
		"Phidget Servo Controller 4-motor",
		"Phidget Servo Controller 1-motor",
		/* Not obsoleted */
		"Phidget Weight Sensor",
		"Phidget Humidity Sensor",
		
		"Phidget PH Sensor",
		"Phidget Gyroscope",
		"Phidget Advanced Servo Controller 8-motor",
		"Phidget RFID 4-output",
		"Phidget TextLED 4x8",
		"Phidget Touch Slider", //linear touch sensor
		"Phidget Touch Rotation", //rotary touch sensor
		"Phidget Encoder 4-encoder 4-input",
		"Phidget GPS",
		"Phidget High Speed Encoder 1-encoder",
		"Phidget Unipolar Stepper Controller 4-motor",
		"Phidget Bipolar Stepper Controller 1-motor",
		"Phidget Joystick Interface Kit",
		"Phidget TextLCD",
		"Phidget InterfaceKit 8/8/8",
		"Phidget Accelerometer 3-axis",
		"Phidget Accelerometer 3-axis",
		"Phidget Gyroscope 3-axis",
		"Phidget Servo Controller 4-motor",
		"Phidget High Current Motor Controller 2-motor",
		"Phidget InterfaceKit 0/0/8"];
		
		public static const Phid_UnknownErrorDescription:String = "Unknown Error Code.";
		

		public static const Phid_Device_Def:Array = [
		[ PHIDDEF_NOTHING_01,			0x000, 0x00],
		[ PHIDDEF_SERVO,				0x6C2, 0x39],
		
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x45],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x40],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x44],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x51],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x53],
		
		[ PHIDDEF_ACCELEROMETER,		0x6C2, 0x71],
		
		[ PHIDDEF_TEXTLCD,				0x6C2, 0x51],
		[ PHIDDEF_TEXTLCD,				0x6C2, 0x52],
		[ PHIDDEF_TEXTLCD,				0x6C2, 0x53],
		
		[ PHIDDEF_RFID,					0x6C2, 0x30],
		
		[ PHIDDEF_LED,					0x6C2, 0x4A],
		[ PHIDDEF_TEXTLED,				0x6C2, 0x49],
		[ PHIDDEF_MOTORCONTROL,			0x6C2, 0x58],
		[ PHIDDEF_TEMPERATURESENSOR,	0x6C2, 0x70],
		[ PHIDDEF_STEPPER,				0x6C2, 0x47],
		[ PHIDDEF_ENCODER,				0x6C2, 0x4B],
		
		/* Obsoleted */
		[ PHIDDEF_INTERFACEKIT,			0x925, 0x8201],
		[ PHIDDEF_SERVO,				0x925, 0x8101],
		[ PHIDDEF_SERVO,				0x925, 0x8104],
		
		/* Not obsoleted */
		[ PHIDDEF_WEIGHTSENSOR,			0x6C2, 0x72],
		[ PHIDDEF_HUMIDITYSENSOR,		0x6C2, 0x73],
		[ PHIDDEF_PHSENSOR,				0x6C2, 0x74],
		[ PHIDDEF_GYROSCOPE,			0x6C2, 0x75],
		[ PHIDDEF_ADVANCEDSERVO,		0x6C2, 0x3A],
		[ PHIDDEF_RFID,					0x6C2, 0x31],
		[ PHIDDEF_TEXTLED,				0x6C2, 0x48],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x76], //linear touch sensor
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x77], //rotary touch sensor
		[ PHIDDEF_ENCODER,				0x6C2, 0x78], //4 encoder
		[ PHIDDEF_GPS,					0x6C2, 0x79], 
		[ PHIDDEF_ENCODER,				0x6C2, 0x80], //high speed encoder
		[ PHIDDEF_STEPPER,				0x6C2, 0x7A], //unipolar stepper
		[ PHIDDEF_STEPPER,				0x6C2, 0x7B],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x7C], //joystick
		[ PHIDDEF_TEXTLCD,				0x6C2, 0x7D],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x7D],
		[ PHIDDEF_ACCELEROMETER,		0x6C2, 0x7E], //3-axis accelerometer
		[ PHIDDEF_ACCELEROMETER,		0x6C2, 0x7F], //AccelGyro composite device
		[ PHIDDEF_GYROSCOPE,			0x6C2, 0x7F], //AccelGyro composite device
		[ PHIDDEF_SERVO,				0x6C2, 0x38],
		[ PHIDDEF_MOTORCONTROL,			0x6C2, 0x59],
		[ PHIDDEF_INTERFACEKIT,			0x6C2, 0x81],
		];
		
		//Socket Server Constants
		//Commands
		public static const NULL_CMD:String = "need nulls";
		public static const LISTEN_CMD:String = "listen";
		public static const IGNORE_CMD:String = "ignore";
		public static const REPORT_CMD:String = "report";
		public static const WAIT_CMD:String = "wait";
		public static const FLUSH_CMD:String = "flush";
		public static const WALK_CMD:String = "walk";
		public static const QUIT_CMD:String = "quit";
		public static const GET_CMD:String = "get";
		public static const SET_CMD:String = "set";
		//responses
		public static const SUCCESS_200_RESP:String = "2";
		public static const FAILURE_300_RESP:String = "3";
		public static const FAILURE_400_RESP:String = "4";
		public static const FAILURE_500_RESP:String = "5";
		public static const AUTHENTICATE_900_RESP:String = "9";
		
		public static const OK_PENDING_RESP:String = "200-";
		public static const OK_RESP:String  = "200 ";
		
		//Listen key change reasons
		public static const VALUE_CHANGED:int = 1;
		public static const ENTRY_ADDED:int = 2;
		public static const ENTRY_REMOVING:int = 3;
		public static const CURRENT_VALUE:int = 4;
	}
}